#VEGAN package R 

install.packages("vegan")
library("vegan")

#starting
setwd("~/Desktop/Tuli thesis/Statistics")
getwd()

#for repeatability, setting a seed to initialize a pseudo-random number generator. 
set.seed(1234)

#opening and cleaning data frames species 
dataDCA <- read.csv (file = "DataPCA.csv", head = TRUE, sep = ";")
DCA<- dataPCA[,2:9] #all data must be numeric, prey species in numbers

#DCA --> met Frank via Canoco gecheckt, moet een DCA zijn 
DCAtest <- rda(DCA)
summary(DCAtest)
plot(DCAtest, arrows = TRUE)

ord<-decorana(DCA)
decorana(veg=DCA)
summary(ord)

plot(ord)
plot(ord, type = "n")
text(ord, display = "sites", cex = 0.9, pch=21, col="black", bg="red", )

text(ord, display = "spec", cex=1, col="black")

